#include "System.h"
#include <algorithm>
using namespace std;
double thlist[10] = { 1.0,0.5,0.2,0.1,0.05,0.02,0.01,0.005,0.002,0.001};
int section_num;
int main(int argc, char** argv) {
	section_num = stoi(argv[1]);
	double th = stod(argv[2]);
	srand(section_num);
	for (int i = 0;i < n_label;i++)
	{
		pr.p[i] = rand() / 32768.0;
		pr.k[i] = rand() / 327680.0;
		for (int j = 0;j < 5;j++)
			pr.A[i][j] = rand() / 32768.0;
	}
	for (int j = 0;j < 5;j++)
		pr.b[j] = rand() / 327.68;
	int n_dataset_index[2] = {}; 
	vector<int> TRAIN_sample_index_array;
	int n_train_sample = 8760;
	vector<int> TRAIN_internal_test_index_array;
	int n_train_intest = 8760;
	
	vector<int> VAL_sample_index_array;
	int n_val_sample = 8760;
	vector<int> VAL_internal_test_index_array;
	int n_val_intest = 8760;


	POF_INITIALIZATION(n_dataset_index);

	auto LOSS_DEFINITION = [](auto r0, auto r1, auto r2, auto r3, auto a0, auto a1, auto a2, auto a3) {
		auto loss = pr.k[0] * a0 * a0 - (pr.p[0] + pr.k[0] * r0) * a0 + pr.k[1] * a1 * a1 - (pr.p[1] + pr.k[1] * r1) * a1+ pr.k[2] * a2 * a2 - (pr.p[2] + pr.k[2] * r2) * a2+ pr.k[3] * a3 * a3 - (pr.p[3] + pr.k[3] * r3) * a3;
		return loss;
	};

	vector<int> total_train_random;
	for (int i = 0; i < n_dataset_index[0]; i++) total_train_random.push_back(i);
	int offset = 0;
	copy(total_train_random.begin() + offset, total_train_random.begin() + offset + n_train_sample, back_inserter(TRAIN_sample_index_array));
	offset += n_train_sample;
	copy(total_train_random.begin() + offset, total_train_random.begin() + offset + n_train_intest, back_inserter(TRAIN_internal_test_index_array));
	offset += n_train_intest;
	copy(total_train_random.begin() + offset, total_train_random.begin() + offset + n_val_intest, back_inserter(VAL_internal_test_index_array));
	offset += n_val_intest;
	copy(total_train_random.begin() + offset, total_train_random.begin() + offset + n_val_sample, back_inserter(VAL_sample_index_array));
	offset += n_val_sample;
	
	cout << total_train_random.size() << " " << TRAIN_sample_index_array.size() << " " << TRAIN_internal_test_index_array.size() << " " << VAL_sample_index_array.size() << " " << VAL_internal_test_index_array.size() << endl;

		srand(unsigned int(time(0)));
		for (int i = 0; i < 500; i++) {
			cout << "@@ (train) iter: " << i << endl;
			vector<int> TRAIN_current_internal_test_index_array = {};
			int n_train_current_intest = 8760;
			copy(TRAIN_internal_test_index_array.begin(), TRAIN_internal_test_index_array.begin() + n_train_current_intest, back_inserter(TRAIN_current_internal_test_index_array));
			POF_TRAIN_BATCH(TRAIN_sample_index_array, TRAIN_current_internal_test_index_array,
				0, 0.2, 1e-2, 0.,
				2, th, 1000., 0.005, 0.00001*(i+1), 23220.0,3060.0,6085.0,20195.0,25021.0,1259.0,11612.0,14668.0);
		}
		for (int i = 0;i < 10;i++)
		{
			th = thlist[i];
			app1_solution TEMP_SOLUTION;
			double temp_loss;
			temp_loss = 0.;
			TEMP_SOLUTION = POF_UTILIZATION(1, VAL_sample_index_array, VAL_internal_test_index_array,
				2, th, 1000., 0.005, 0.005, 23220.0, 3060.0, 6085.0, 20195.0, 25021.0, 1259.0, 11612.0, 14668.0);
			double best_loss = 0, ulti_best_loss = 0;
			for (int i = 0; i < USER_API.get_nndata("n_sample"); i++)
			{
				temp_loss += LOSS_DEFINITION(USER_API.get_nndata("batch_ans", 0, i), USER_API.get_nndata("batch_ans", 1, i), USER_API.get_nndata("batch_ans", 2, i), USER_API.get_nndata("batch_ans", 3, i), TEMP_SOLUTION.mainsol_batch[i][0][0], TEMP_SOLUTION.mainsol_batch[i][1][0], TEMP_SOLUTION.mainsol_batch[i][2][0], TEMP_SOLUTION.mainsol_batch[i][3][0]);
				best_loss += SOLUTION.best_loss[i];
				ulti_best_loss += SOLUTION.ulti_best_loss[i];
			}
			int max_vio = 0;
			for (int l = 0;l < 4;l++)
				max_vio = max_vio > SOLUTION.vio[l] ? max_vio : SOLUTION.vio[l];
			write_log("VAL", th, temp_loss, max_vio, best_loss, ulti_best_loss);
			FILE* out;
			char fname[100];
			sprintf_s(fname, "result_or_%d_%lf.txt", section_num, th);
			fopen_s(&out, fname, "w");
			fprintf(out, "%lf\t%d\t%lf\t%lf", temp_loss, max_vio, best_loss, ulti_best_loss);
			fclose(out);
		}
	return 0;
}